package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestReview extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {

		Review review = Review.findById(0);
		Assert.assertNull(review);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		List<ReviewTemplate> rtList = ReviewTemplate.listAll();
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
		
		ReviewTemplate template = rtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Group reviewer = template.getReviewer();
		Assert.assertNotNull(reviewer);
		Assert.assertTrue(reviewer.getId() > 0);

		Review rev = Review.create(null, request, template, reviewer, "Please do this review"); // request, template, group, string
		Assert.assertNotNull(rev);
		Assert.assertTrue(rev.getId() > 0);
		
		List<Review> rList = Review.listByRequestId(request.getId());
		 
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);
		Assert.assertTrue(rList.contains(rev));
	}

	@Test
	public void testTwo() throws Exception {

		Review review = Review.findById(0);
		Assert.assertNull(review);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		List<ReviewTemplate> rtList = ReviewTemplate.listAll();
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
		
		ReviewTemplate template = rtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Group reviewer = template.getReviewer();
		Assert.assertNotNull(reviewer);
		Assert.assertTrue(reviewer.getId() > 0);

		Review rev = Review.create(null, request, template, reviewer, "Please do this review"); // request, template, group, string
		Assert.assertNotNull(rev);
		Assert.assertTrue(rev.getId() > 0);
		
		List<Review> rList = Review.listByRequestId(request.getId());
		 
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);
		Assert.assertTrue(rList.contains(rev));
	}

	@Test
	public void testThree() throws Exception {

		Review review = Review.findById(0);
		Assert.assertNull(review);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		List<ReviewTemplate> rtList = ReviewTemplate.listAll();
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
		
		ReviewTemplate template = rtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Group reviewer = template.getReviewer();
		Assert.assertNotNull(reviewer);
		Assert.assertTrue(reviewer.getId() > 0);

		Review rev = Review.create(null, request, template, reviewer, "Please do this review"); // request, template, group, string
		Assert.assertNotNull(rev);
		Assert.assertTrue(rev.getId() > 0);
		
		List<Review> rList = Review.listByGroupId(reviewer.getId());
		 
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);
		Assert.assertTrue(rList.contains(rev));
	}

	@Test
	public void testFour() throws Exception {

		Review review = Review.findById(0);
		Assert.assertNull(review);

		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		List<ReviewTemplate> rtList = ReviewTemplate.listAll();
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
		
		ReviewTemplate template = rtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Group reviewer = template.getReviewer();
		Assert.assertNotNull(reviewer);
		Assert.assertTrue(reviewer.getId() > 0);

		Review rev = Review.create(null, request, template, reviewer, "Please do this review"); // request, template, group, string
		Assert.assertNotNull(rev);
		Assert.assertTrue(rev.getId() > 0);
		
		List<Review> rList = Review.listByRequestId(request.getId());
		 
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);
		Assert.assertTrue(rList.contains(rev));
		
		rev.delete();

		rList = Review.listByRequestId(request.getId());
		 
		Assert.assertNotNull(rList);
		Assert.assertFalse(rList.contains(rev));
	}
}
